<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Contest_Leaderboard extends Model
{
    use HasFactory;

    protected $table = 'tbl_contest_leaderboard';
    protected $guarded = array();

    protected $casts = [
        'id' => 'integer',
        'contest_id' => 'integer',
        'user_id' => 'integer',
        'total_questions' => 'integer',
        'questions_attended' => 'integer',
        'correct_answers' => 'integer',
        'percentage' => 'integer',
        'question_json' => 'string',
        'rank' => 'integer',
        'winning_coin' => 'integer',
        'status' => 'integer',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
